package com.roco.settle.api.request.productconfig;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SettleEnterpriseProductRelEditReq implements Serializable {
    @NotBlank
    private String model;
    @NotBlank
    private String enterpriseCode;
    @NotBlank
    private String enterpriseName;

    private String piccOrgCode;
    @NotBlank
    private String productCode;
    @NotNull
    private BigDecimal sellPrice;

    private String code;
    /**
     * 是否默认配置
     */
    @Pattern(regexp = ("^(Y|N)$"),message = "是否默认配置参数不匹配")
    @NotBlank(message = "是否默认配置不可以为空！")
    private String isDefault;
}
