package com.roco.settle.api.request.supplier.product;

import com.roco.settle.api.enums.product.ProductNature;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Andrew
 * @create 2020/2/19 11:15 上午
 */
@Data
public class ProductUpdateReq extends BasePrimaryKeyRequest implements Serializable {

    /**
     * 第三方平台编码
     */
    private String thirdPlatformCode;

    /**
     * 第三方产品编码
     */
    private String thirdPlatformProductCode;

    /**
     * 采购价
     */
    private BigDecimal purchasePrice;

    /**
     * 名称
     */
    @NotBlank
    private String name;

    /**
     * 简称
     */
    @NotBlank
    private String simpleName;
    /**
     * 供应商编号
     */
    @NotBlank
    private String supplierNo;
    /**
     * 类目编码
     */
    @NotBlank
    private String catalogCode;
    /**
     * 品牌编码
     */
    @NotBlank
    private String brandCode;
    /**
     * 面值
     */
    private BigDecimal price;
    /**
     * 充值折扣
     */
    private BigDecimal discount;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;
    /**
     * 说明
     */
    private String remark;

    /**
     * 上游商品编号
     */
    private String  upstreamCode;

    /**
     * 商品性质
     */
    private ProductNature nature;


    /**
     * 商品摘要
     */
    private String productBrief;


    /**
     * 供应商渠道名称
     */
    private String channelName;


    /**
     * 供应商渠道编号
     */
    private String channelCode;

}
