package com.roco.settle.api.service.productconfig;

import com.roco.settle.api.entity.productconfig.SettleEnterpriseProduct;
import com.roco.settle.api.entity.supplier.ReceiptAccount;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductRelBatchEditReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductRelEditReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductRelSearchReq;
import com.roco.settle.api.request.supplier.supplychain.ReceiptAccountReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

public interface SettleEnterpriseProductRelService {

    CommonResponse<Boolean> update(CommonRequest<SettleEnterpriseProductRelEditReq> request);

    CommonResponse<Boolean> batchUpdate(CommonRequest<SettleEnterpriseProductRelBatchEditReq> request);

    CommonQueryPageResponse<SettleEnterpriseProduct> query(CommonQueryPageRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<SettleEnterpriseProduct> detail(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<SettleEnterpriseProduct> detailByEnterpriseCode(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<SettleEnterpriseProduct> getByproductCode(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<List<SettleEnterpriseProduct>> listProducts(CommonRequest<SettleEnterpriseProductRelSearchReq> request);
    /**
     * 根据机构编码
     * 获取机构默认配置
     * @param request
     * @return
     * */
    CommonResponse<SettleEnterpriseProduct> getDefault(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    /**
     * 检查机构产品配置
     * 机构产品结算信息配置
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseProduct> checkEnterpriseProductConfig(CommonRequest<SettleEnterpriseProductRelSearchReq> request);
}
