package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.ext.ProductSupplierDepositDTO;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.supplier.product.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.entity.supplier.ext.ProductExt;

/**
 * @author Andrew
 * @create 2020/2/19 11:14 上午
 */
public interface ProductService {

    /**
     * 新增商品
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<ProductSaveReq> request);


    /**
     * 分页查询商品
     * @param request
     * @return
     */
    CommonQueryPageResponse<ProductExt> page(CommonQueryPageRequest<ProductPageReq> request);

    /**
     * 商品详情
     * @param request
     * @return
     */
    CommonResponse<ProductExt> detail(CommonRequest<BasePrimaryKeyRequest> request);


    /**
     * 变更状态
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<ProductStatusUpdateReq> request);


    /**
     * 商品修改
     * @param request
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<ProductUpdateReq> request);



    /**
     * 根据产品编号查询商品详情
     * @param request
     * @return
     */
    CommonResponse<ProductExt> detailByCode(CommonRequest<ProductDetailReq> request);



    /**
     * 新增或者保存平台商品与备付金账户关联关系
     * @param request
     * @return
     */
    CommonResponse<Boolean> saveOrUpdateProductReferenceAcct (CommonRequest<ProductReferenceSupplierDepositReq> request);



    /**
     * 根据产品编号查询关联的备付金账户信息
     * @param request
     * @return
     */
    CommonResponse<ProductSupplierDepositDTO> acctInfoDetailByCode(CommonRequest<ProductDetailReq> request);
}
