package com.roco.settle.api.request.enterprisetansfer;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 对公转账
 *
 * @author Andrew
 * @create 2020/2/24 10:38 上午
 */
@Data
public class EnterpriseTransferApplyReq implements Serializable {


    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    /**
     * 业务基点简称
     */
    private String enterpriseSimpleName;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     * 是否人保机构
     */
    private Long isPicc;

    /**
     * 人保机构编码
     */
    private String piccOrgCode;

    /**
     * 事项名称
     */
    @Length(max = 50, message ="事项名称不能超过50个字")
    private String itemName;

    /**
     * 事项说明
     */
    @Length(max = 500, message ="事项说明不能超过500个字")
    private String itemDesc;

    /**
     * 供应商编码
     */
    private String supplierCode;


    /**
     * 供应商收款账号
     */
    private String supplierAccountNo;


    /**
     * 文件上传的时候存入redis, 临时key,
     * 提交的时候去redis 里面取
     */
    private String tempFileId;


    /**
     * 是否提交
     */
    private boolean submit;


}
