package com.roco.settle.api.entity.enterprise.transaction;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.enterprise.transaction.ToBusinessTransactionBusinessStatusEnum;
import com.roco.settle.api.enums.enterprise.transaction.ToBusinessTransactionSettleStatusEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/2 14:49</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "settle_enterprise_to_business_transaction")
public class SettleEnterpriseToBusinessTransaction implements Serializable {
    /**
     * 主键
     */
    @Id
    private Long id;

    /**
     * 业务基点业务基点TOB业务登记
     */
    private String code;

    /**
     * 业务编码
     */
    private String businessCode;

    /**
     * 销售主体编码
     */
    private String bizSubjectCode;

    /**
     * 销售主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 机构编码(业务基点)
     */
    private String enterpriseCode;

    /**
     * 机构简称（业务基点）
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 是否人保；0否、1是
     */
    private Long isPicc;

    /**
     * 发生日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate businessDate;

    /**
     * 业务金额
     */
    private BigDecimal businessAmount;

    /**
     * 结算金额
     */
    private BigDecimal settleAmount;

    /**
     * 说明
     */
    private String introduction;

    /**
     * 结算状态:UNSETTLE:未结算SETTLEED:已结算
     */
    @Column(name = "settle_status")
    private ToBusinessTransactionSettleStatusEnum settleStatus;

    /**
     * 业务状态
     * 待确认：WAIT_CONFIRMED
     * 待处理：WAIT_PROCESS
     * 已处理：FINISHED
     * 已作废：INVALID
     */
    @Column(name = "business_status")
    private ToBusinessTransactionBusinessStatusEnum businessStatus;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     */
    private String createUsertype;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;

    /**
     * 更新人类型
     */
    private String updateUsertype;

    /**
     * 逻辑删除（0：未删除，1：已删除）
     */
    private Long deleted;

    /**
     * 确认日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate confirmDate;

    /**
     * 确认备注
     */
    private String confirmRemark;

    /**
     * 处理日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate handleDate;

    /**
     * 处理备注
     */
    private String handleRemark;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate settleDate;

    /**
     * 结算备注
     */
    private String settleRemark;

    /**
     * 取消时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate cancelTime;

}