package com.roco.settle.api.entity.enterprisetansfer;

import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 对公转账操作日志(SettleEnterpriseTransferApplyLog)实体类
 *
 * @author Andrew
 * @since 2020-02-24 10:21:12
 */
@Data
@Table(name = "settle_enterprise_transfer_apply_log")
public class SettleEnterpriseTransferApplyLog implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 操作之前的状态  
     */
    private String beforeStatus;

    /**
     * 操作备注  
     */
    private String operationDesc;

    /**
     * 操作类型  
     */
    private String operationType;

    /**
     * 操作之后的状态
     */
    private String afterStatus;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

   

}