package com.roco.settle.api.entity.policy;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 保单直投申请单(PolicyGiftDirectApply)实体类
 *
 * @author luoyingchang
 * @since 2020-07-14 13:21:21
 */
@Data
@Table(name = "policy_gift_direct_apply")
public class PolicyGiftDirectApply implements Serializable {


    @Id
    private Integer id;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String enterpriseName;

    /**
     * 推修码
     */
    private String repairNo;

    /**
     * 渠道商编码(推修码)
     */
    private String channelCode;

    /**
     * 渠道商名称
     */
    private String channelName;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 模式: 额度:quota、比例:ratio
     */
    private String giftMode;

    /**
     * 口径(保费模式) 保费:premium、净保费:net_premium
     */
    private String policyType;

    /**
     * 比例 例如: 100% =  1.0000、52.3% = 0.5230 3.21% = 0.0321
     */
    private BigDecimal ratio;

    /**
     * 申请单号(唯一)
     */
    private String applyNo;

    /**
     * 申请附件
     */
    private String applyFileUrl;

    /**
     * 总金额
     */
    private BigDecimal totalAmount;

    /**
     * 申请备注
     */
    private String remark;

    /**
     * 申请数量
     */
    private Integer applyCount;

    /**
     * 处理数量
     */
    private Integer handleCount;

    /**
     * 结算数量
     */
    private Integer settleCount;

    /**
     * 申请人id
     */
    private Integer createUser;

    /**
     * 申请人姓名
     */
    private String createName;

    /**
     * 申请人类型 customer, system
     */
    private String createUsertype;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 申请日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 状态 作废invalid、提交:submit、草稿:draft
     */
    private String status;

    /**
     * 业务状态 待处理:pending、已处理:processed、已作废:invalid
     */
    private String bizStatus;

    /**
     * 结算状态 未结算:unsettled、已结算:settled
     */
    private String settleStatus;

    /**
     * 处理时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime handleTime;

    /**
     * 处理日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate handleDate;

    /**
     * 结算时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime settleTime;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate settleDate;

    /**
     * 提交时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime submitTime;

    /**
     * 提交日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate submitDate;

    /**
     * 作废时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime invalidTime;

    /**
     * 作废日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate invalidDate;

}