package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.Supplier;
import com.roco.settle.api.entity.supplier.SupplierChannel;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.base.NoArgsRequest;
import com.roco.settle.api.request.supplier.supplychain.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.supplier.catalog.SupplierRes;
import com.roco.settle.api.response.supplier.catalog.SupplierWithAccoutRes;

import java.util.List;

public interface SupplierService {

    /**
     * 查询单条记录
     * @param request
     */
    CommonResponse<SupplierRes> get(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 保存
     * @param request
     */
    CommonResponse<Boolean> save(CommonRequest<SupplierSaveReq> request);
    /**
     * 更新
     * @param request
     */
    CommonResponse<Boolean> update(CommonRequest<SupplierSaveReq> request);
    /**
     * 删除
     * @param request
     */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 供应商列表
     * */
    CommonQueryPageResponse<Supplier> search(CommonQueryPageRequest<SupplierPageReq> request);
    /**
     * 供应商列表
     * */
    CommonQueryPageResponse<Supplier> searchForExpenseItem(CommonQueryPageRequest<SupplierPageForExpenseItemReq> request);

    /**
     * 根据供应商状态为启用
     * 是否默认 isDefault
     * 获取供应商信息
     * */
    CommonResponse<List<Supplier>> all(CommonRequest<SupplierReq> request);

    /**
     * 更新状态
     * @param request
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SupplierUpdateStatusReq> request);

    CommonResponse<SupplierRes> getByCode(CommonRequest<SupplierReq>  request);

    /**
     *导出
     * */
    CommonResponse<List<SupplierWithAccoutRes>> export(CommonRequest<SupplierPageReq> request);

    /**
     *数据清洗
     * */
    CommonResponse<Boolean> processData(CommonRequest<NoArgsRequest> request);
    /**
     * 查询全部
     * @param request
     * @return
     */
    CommonResponse<List<SupplierRes>> getByCodes(CommonRequest<SupplierCodesReq> request);

    /**
     * 根据条件不分页查询供应商
     * @param request
     * @return
     */
    CommonResponse<List<Supplier>>  searchByParams(CommonRequest<SupplierReq> request);
}
