package com.roco.settle.api.entity.enterprisesettle;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.roco.settle.api.util.DateUtil;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 业务基点->油卡结算申请操作日志
 *
 * @author zhangmin
 * @since 2020-02-29 10:21:12
 */
@Setter
@Getter
@Table(name = "settle_enterprise_oilcard_apply_log")
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettleEnterpriseOilCardApplyLog implements Serializable {

    @Id
    private Long id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 操作之前的状态  
     */
    private String beforeStatus;

    /**
     * 操作备注  
     */
    private String operationDesc;

    /**
     * 操作类型  
     */
    private String operationType;

    /**
     * 操作之后的状态
     */
    private String afterStatus;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

}