package com.roco.settle.api.service.enterprise.transaction;

import com.roco.settle.api.entity.enterprise.transaction.SettleEnterpriseToBusinessTransaction;
import com.roco.settle.api.entity.enterprise.transaction.SettleEnterpriseToBusinessTransactionOperation;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.base.NoArgsRequest;
import com.roco.settle.api.request.enterprise.transaction.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.enterprise.transaction.SettleEnterpriseToBusinessTransactionRes;

/**
 * 业务基点TOB业务登记(SettleEnterpriseToBusinessTransaction)表服务接口
 *
 * @author 兰倩
 * @since 2020/07/03 14:00
 */
public interface SettleEnterpriseToBusinessTransactionService {
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseToBusinessTransaction
     */
    CommonResponse<SettleEnterpriseToBusinessTransaction> get(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseToBusinessTransaction
     */
    CommonResponse<SettleEnterpriseToBusinessTransactionRes> getExt(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseToBusinessTransaction
     */
    CommonResponse<SettleEnterpriseToBusinessTransactionRes> getByCode(CommonRequest<SettleEnterpriseToBusinessTransactionReq> request);

    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> save(CommonRequest<SettleEnterpriseToBusinessTransactionSaveReq> request);
    /**
     * 更新记录
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> update(CommonRequest<SettleEnterpriseToBusinessTransactionUpdateReq> request);


    /**
     * 确认
     * @param request {id, confirmDate}
     * @return
     * */
    CommonResponse<String> confirm(CommonRequest<SettleEnterpriseToBusinessTransactionReq> request);
    /**
     * 作废
     * @param request
     * @return
     * */
    CommonResponse<Boolean> invalid(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     *处理确认
     * @param request
     * @return
     * */
    CommonResponse<Boolean> handle(CommonRequest<SettleEnterpriseToBusinessTransactionHandleReq> request);
    /**
     * 结算确认
     * @param request
     * @return
     * */
    CommonResponse<Boolean> settle(CommonRequest<SettleEnterpriseToBusinessTransactionSettleReq> request);
    /**
     * 列表-分页
     * @param request 关键字
     * @return 分页查询实体
     */
    CommonQueryPageResponse<SettleEnterpriseToBusinessTransaction> search(CommonQueryPageRequest<SettleEnterpriseToBusinessTransactionPageReq> request);

    /**
     * 查询操作日志
     * */
    CommonQueryPageResponse<SettleEnterpriseToBusinessTransactionOperation> searchOperation(CommonQueryPageRequest<SettleEnterpriseToBusinessTransactionOperationPageReq> request);

    CommonResponse<Boolean> processStatistic(CommonRequest<NoArgsRequest> request);
}