package com.roco.settle.api.service.expense;


import com.roco.settle.api.entity.expense.SettleExpenseItem;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.expense.item.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

/**
 * 费用项目管理(SettleExpenseItem)表服务接口
 *
 * @author 兰倩
 * @since 2020-03-10 17:03:21
 */
public interface SettleExpenseItemService {

    /**
     * 通过ID查询单条数据
     *
     * @param request 主键
     * @return 实例对象
     */
    CommonResponse<SettleExpenseItem>  get(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 通过code查询单条数据
     *
     * @param request 主键
     * @return 实例对象
     */
    CommonResponse<SettleExpenseItem>  getByCode(CommonRequest<SettleExpenseItemReq> request);

    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> save(CommonRequest<SettleExpenseItemSaveReq> request);

    /**
     * 更新记录
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> update(CommonRequest<SettleExpenseItemUpdateReq>request);

    /**
     * 列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<SettleExpenseItem> search(CommonQueryPageRequest<SettleExpenseItemPageReq> request);

    /**
     * 查询全部
     * @param request
     * @return
     */
    CommonResponse<List<SettleExpenseItem>> all(CommonRequest<SettleExpenseItemReq> request);

    /**
     * 删除
     * 参数 id
     * @param request
     * @return
     * */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest>  request);

    /**
     * 更新状态
     * @param request
     * @return
     * */
    CommonResponse<Boolean> updateStatus(CommonRequest<SettleExpenseItemUpdateStatusReq>  request);

    /**
     * 查询全部
     * @param request
     * @return
     */
    CommonResponse<List<SettleExpenseItem>> getByCodes(CommonRequest<SettleExpenseItemCodesReq> request);
}