package com.roco.settle.api.entity.invoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.invoice.InvoiceOperationTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/21 15:45</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name="invoice_file")
public class InvoiceFile  implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 发票申请单号
     */
    private String applyNo;

    /**
     * 文件类型(PDF,PNG,JPG,JPEG)
     */
    private String fileType;

    /**
     * 路径url
     */
    private String fileurl;

    /**
     * 附件名称
     */
    private String fileName;

    /**
     * 附件说明
     */
    private String remark;

    /**
     * 操作类型
     */
    @Column(name="oper_type")
    private InvoiceOperationTypeEnum operType;

    /**
     * 上传时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    public InvoiceFile(String applyNo, String fileType, String fileurl, String fileName, String remark, InvoiceOperationTypeEnum operType, LocalDateTime createTime, String createUser, String createName) {
        this.applyNo = applyNo;
        this.fileType = fileType;
        this.fileurl = fileurl;
        this.fileName = fileName;
        this.remark = remark;
        this.operType = operType;
        this.createTime = createTime;
        this.createUser = Long.valueOf(createUser) ;
        this.createName = createName;
    }

}