package com.roco.settle.api.request.policy;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @author luoyingchang
 * @date 2020-07-14
 */
@Getter
@Setter
public class PolicyGiftDirectApplyQueryReq implements Serializable {

    /**
     * 机构编码
     */
    private String enterpriseCode;



    /**
     * 推修码
     */
    private String repairNo;



    /**
     * 申请单号(唯一)
     */
    private String applyNo;



    /**
     * 状态 作废invalid、提交:submit、草稿:draft
     */
    private String status;

    /**
     * 业务状态 待处理:pending、已处理:processed、已作废:invalid
     */
    private String bizStatus;

    /**
     * 结算状态 未结算:unsettled、已结算:settled
     */
    private String settleStatus;

    private List<String> enterpriseCodes;



    /**
     * 默认不显示草稿
     */
    private boolean showDraft;

}
