package com.roco.settle.api.request.productconfig;

import com.roco.settle.api.annotation.Punctuation;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author djt
 * @date 2020/7/3 10:29
 */
@Data
public class SettleProductPackageSaveReq implements Serializable {


    /**
     * 套餐编号
     */
    private String code;


    /**
     * id
     */
    private Long id;

    /**
     * 机构编码
     */
    @NotBlank
    private String enterpriseCode;

    /**
     * 机构简称
     */
    @NotBlank
    private String enterpriseSimpleName;

    /**
     * 销售主体编号
     */
    @NotBlank
    private String subjectCode;

    /**
     * 销售主体简称
     */
    @NotBlank
    private String subjectSimpleName;

    /**
     * 套餐编码
     */
    @Length(max = 64,message = "套餐编码最多64个字符")
    @NotBlank
    private String productPackageCode;

    /**
     * 套餐名称
     */
    @NotBlank
    @Punctuation(message = "套餐名称不能含有标点符号")
    private String productPackageName;

    /**
     * 套餐总面值
     */
    @NotNull
    private Integer faceValue;


    /**
     * 套餐总面值
     */
    @NotNull
    @Digits(integer = 9,fraction = 3)
    private BigDecimal sellingPrice;

    /**
     * 套餐产品数
     */
    @Min(1)
    @NotNull
    private Integer productCnt;

    /**
     * 套餐说明
     */
    @Length(max = 500,message = "套餐说明最多500个字符")
    private String remark;

    /**
     * 套餐状态
     */
    @NotNull
    private Integer status;

    /**
     * 默认套餐
     */
    @NotNull
    private Integer isDefault;

    /**
     * 套餐产品列表
     */
    @NotNull
    @Size(min = 1)
    @Valid
    private List<SettleProductPackageItemSaveReq> items;

}
