package com.roco.settle.api.service.subject;

import com.roco.settle.api.entity.subject.SettleSubjectProductRef;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.subject.EnterpriseSettleSubjectProductRefReq;
import com.roco.settle.api.request.subject.SettleSubjectProductRefReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.subject.SettleSubjectProductRefResp;

/**
 * @author hsf
 * @date 2020-07-02 14:28
 */
public interface SettleSubjectProductRefService {

    CommonResponse<Boolean> save(CommonRequest<SettleSubjectProductRefReq> request);

    CommonResponse<Boolean> update(CommonRequest<SettleSubjectProductRefReq> request);

    CommonResponse<Boolean> delete(CommonRequest<SettleSubjectProductRefReq> request);

    CommonResponse<SettleSubjectProductRef> detail(CommonRequest<SettleSubjectProductRefReq> request);

    CommonQueryPageResponse<SettleSubjectProductRefResp> page(CommonQueryPageRequest<SettleSubjectProductRefReq> request);


    /**
     * 根据机构编号及销售主体编号查询尚未关联的销售主体可售产品
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleSubjectProductRefResp> selectNoRelProduct(CommonQueryPageRequest<EnterpriseSettleSubjectProductRefReq> request);


}
