package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.Catalog;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.base.NoArgsRequest;
import com.roco.settle.api.request.supplier.catalog.CatalogPageReq;
import com.roco.settle.api.request.supplier.catalog.CatalogReq;
import com.roco.settle.api.request.supplier.catalog.CatalogSaveReq;
import com.roco.settle.api.request.supplier.catalog.CatalogUpdateStatusReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.supplier.catalog.CatalogDto;
import com.roco.settle.api.response.tree.ZtreeDto;

import java.util.List;

/**
 * @author Andrew
 * @create 2020/2/19 11:14 上午
 */
public interface CatalogService {
    /**
     * 查询单条记录
     * @param  request
     * @return Catalog
     */
    CommonResponse<Catalog> get(CommonRequest<BasePrimaryKeyRequest>  request);
    /**
     * 新增保存类目
     * */
    CommonResponse<Boolean> save(CommonRequest<CatalogSaveReq> request);
    /**
     * 更新类目记录
     * */
    CommonResponse<Boolean> update(CommonRequest<CatalogSaveReq>request);
    /**
     * 删除类目
     * 参数 id
     * */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest>  request);
    /**
     * 商品分类列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<Catalog> search(CommonQueryPageRequest<CatalogPageReq> request);

    /**
     * 查询全部商品分类
     * @param request
     * @return
     */
    CommonResponse<List<Catalog>> all(CommonRequest<CatalogReq> request);

    /**
     * 获取最大排序值加1
     * 参数 pid
     * @return
     */
    CommonResponse<Integer> getMaxSerialNumberByPid(CommonRequest<BasePrimaryKeyRequest>  request);

    /**
     * 获取类目信息，构建前端树形选择框
     * */

    CommonResponse<List<ZtreeDto>> getCategoryZTreeList(CommonRequest<NoArgsRequest> request);

    /**
     * 获取类目的树形列表
     * */
    CommonResponse<List<CatalogDto>> findCategoryTree(CommonRequest<NoArgsRequest> request);

    /**
     * 根据ID获取类目和父类目信息
     * */
    CommonResponse<Catalog> getCatalogById(CommonRequest<BasePrimaryKeyRequest>  request);

    /**
     * 更新类目状态
     * */
    CommonResponse<Boolean> updateStatus(CommonRequest<CatalogUpdateStatusReq>  request);

    /**
     * 根据code获取类目和父类目信息
     * */
    CommonResponse<Catalog> getByCode(CommonRequest<CatalogReq>  request);
}
