package com.roco.settle.api.entity.subject;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * (SettleSubjectProductRefHistory)实体类
 *
 * @author hsf
 * @since 2020-07-08 14:06:20
 */
@Data
@Table(name = "settle_subject_product_ref_history")
public class SettleSubjectProductRefHistory implements Serializable {

   
    @Id
    private Long id;

    /**
     * 编码
     */
    private String code;

    /**
     * 业务主体id(settle_biz_subject.code)  
     */
    private String subjectCode;

    /**
     * 业务主体简称(settle_biz_subject.simple_name)  
     */
    private String subjectSimpleName;

    /**
     * 可售产品编号(product.code)  
     */
    private String productCode;

    /**
     * 默认的通道产品(third_platform_product.code)  
     */
    private String thirdProductCode;

    /**
     * 产品销售价
     */
    private BigDecimal productSellPrice;

    /**
     * 更新人  
     */
    private String updateUser;

    /**
     * 更新人名称  
     */
    private String updateUserName;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

   

}