package com.roco.settle.api.request.enterprise.transaction;

import com.roco.settle.api.enums.enterprise.transaction.ToBusinessTransactionBusinessStatusEnum;
import com.roco.settle.api.enums.enterprise.transaction.ToBusinessTransactionSettleStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author lanqian
 */
@Data
public class SettleEnterpriseToBusinessTransactionPageReq implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 业务基点业务基点TOB业务登记
     */
    private String code;

    /**
     * 业务编码
     */
    private String businessCode;

    /**
     * 销售主体编码
     */
    private String bizSubjectCode;

    /**
     * 销售主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 机构编码(业务基点)
     */
    private String enterpriseCode;

    /**
     * 机构简称（业务基点）
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 是否人保；0否、1是
     */
    private Long isPicc;

    /**
     * 发生日期
     */
    private LocalDate businessDate;
    /**
     * 发生日期
     */
    private LocalDate businessDateEnd;
    /**
     * 结算状态:UNSETTLE:未结算SETTLEED:已结算
     */
    private ToBusinessTransactionSettleStatusEnum settleStatus;

    /**
     * 业务状态
     * 待确认：WAIT_CONFIRMED
     * 待处理：WAIT_PROCESS
     * 已处理：FINISHED
     * 已作废：INVALID
     */
    private ToBusinessTransactionBusinessStatusEnum businessStatus;
    /**
     * 逻辑删除（0：未删除，1：已删除）
     */
    private Long deleted;

    /**
     * 确认日期
     */
    private LocalDate confirmDate;

    /**
     * 处理日期
     */
    private LocalDate handleDate;
    /**
     * 处理日期
     */
    private LocalDate handleDateEnd;


    /**
     * 结算日期
     */
    private LocalDate settleDate;
    /**
     * 结算日期
     */
    private LocalDate settleDateEnd;


    /**
     * 取消时间
     */
    private LocalDate cancelTime;
}
