package com.roco.settle.api.request.policy;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @author luoyingchang
 * @date 2020-07-14
 */
@Getter
@Setter
public class PolicyGiftDirectApplyReq implements Serializable {

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String enterpriseName;

    /**
     * 推修码
     */
    private String repairNo;

    /**
     * 渠道商编码(推修码)
     */
    private String channelCode;

    /**
     * 渠道商名称
     */
    private String channelName;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 模式: 额度:quota、比例:ratio
     */
    private String giftMode;

    /**
     * 口径(保费模式) 保费:premium、净保费:net_premium
     */
    private String policyType;

    /**
     * 比例 例如: 100% =  1.0000、52.3% = 0.5230 3.21% = 0.0321
     */
    private BigDecimal ratio;

    /**
     * 申请单号(唯一)
     */
    private String applyNo;

    /**
     * 申请附件
     */
    private String applyFileUrl;

    /**
     * 总金额
     */
    private BigDecimal totalAmount;

    /**
     * 申请备注
     */
    private String remark;

    /**
     * 申请数量
     */
    private Integer applyCount;

    /**
     * 处理数量
     */
    private Integer handleCount;

    /**
     * 结算数量
     */
    private Integer settleCount;




    private List<PolicyGiftDirectDetailReq> detailReqList;

    private String enterpriseCodes;

    /**
     * 处理日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate handleDate;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate settleDate;

    /**
     * 直投机构选择模式
     */
    private String enterpriseChooseMode;

    /**
     * 机构渠道商选择模式
     */
    private String channelChooseMode;

}
