package com.roco.settle.api.service.productconfig;

import com.roco.settle.api.entity.productconfig.SettleEnterpriseProduct;
import com.roco.settle.api.entity.supplier.ReceiptAccount;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductRelAvailableUpdateReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductRelBatchEditReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductRelEditReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductRelSearchReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseProductUpdateAmountReq;
import com.roco.settle.api.request.supplier.supplychain.ReceiptAccountReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

public interface SettleEnterpriseProductRelService {

    CommonResponse<Boolean> update(CommonRequest<SettleEnterpriseProductRelEditReq> request);

    CommonResponse<Boolean> batchUpdate(CommonRequest<SettleEnterpriseProductRelBatchEditReq> request);

    CommonQueryPageResponse<SettleEnterpriseProduct> query(CommonQueryPageRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<SettleEnterpriseProduct> detail(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<SettleEnterpriseProduct> detailByEnterpriseCode(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<SettleEnterpriseProduct> getByproductCode(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    CommonResponse<List<SettleEnterpriseProduct>> listProducts(CommonRequest<SettleEnterpriseProductRelSearchReq> request);
    /**
     * 根据机构编码
     * 获取机构默认配置
     * @param request
     * @return
     * */
    CommonResponse<SettleEnterpriseProduct> getDefault(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    /**
     * 多机构单产品配置
     * @param request
     * @return
     */
    CommonResponse<Boolean> enterprisesAddProduct(CommonRequest<SettleEnterpriseProductRelBatchEditReq> request);


    /**
     * 单机构-多产品配置
     * @param request
     * @return
     */
    CommonResponse<Boolean> enterpriseAddProducts(CommonRequest<SettleEnterpriseProductRelBatchEditReq> request);


    /**
     * 根据企业编号及产品编号查询企业产品结算信息
     * @param request
     * @return
     */
    CommonResponse<List<SettleEnterpriseProduct>> getProductSettlementByEnterpriseAndProductCodes(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    /**
     * 检查机构产品配置
     * 机构产品结算信息配置
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseProduct> checkEnterpriseProductConfig(CommonRequest<SettleEnterpriseProductRelSearchReq> request);


    /**
     * 不分页查询所有机构产品
     * @param request
     * @return
     */
    CommonResponse<List<SettleEnterpriseProduct>> all(CommonRequest<SettleEnterpriseProductRelSearchReq> request);


    /**
     * 根据机构编码查询可配置拆单限额产品
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseProduct> getByProductType(CommonQueryPageRequest<SettleEnterpriseProductRelSearchReq> request);


    /**
     * 更新机构产品拆单金额
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateAmountLimit(CommonRequest<SettleEnterpriseProductUpdateAmountReq> request);


    /**
     * 根据机构产品编码查询机构产品配置限额和对应的渠道限额
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseProduct> getAmountLimit(CommonRequest<SettleEnterpriseProductRelSearchReq> request);

    /**
     * 机构产品上下架
     * @param request
     * @return
     */
    CommonResponse<Boolean> availableOnOff(CommonRequest<SettleEnterpriseProductRelAvailableUpdateReq> request);

}
