package com.roco.settle.api.entity.invoice;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.invoice.InvoiceOperationTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 发票操作记录
 * @author dongjuntong
 */
@Data
@Table(name="invoice_operate_log")
public class InvoiceOperationLog implements Serializable {

    /**
     * id
     */
    @Id
    private Long id;

    /**
     * 发票入库申请编号
     */
    private String invoiceApplyCode;

    /**
     * 操作行为
     */
    private String operation;

    /**
     * 操作人id
     */
    private Long createUser;


    /**
     * 操作人名称
     */
    private String createName;


    /**
     * 操作时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 操作备注
     */
    private String remark;


}
