package com.roco.settle.api.request.enterprise.transaction;

import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 业务基点TOB业务登记(SettleEnterpriseToBusinessTransaction)请求实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:24:25
 */
@Data
public class SettleEnterpriseToBusinessTransactionUpdateReq implements Serializable {
    /**
     * 主键
     */
    @NotNull(message = "主键不可为空")
    private Long id;

    /**
     * 业务基点业务基点TOB业务登记
     */
    private String code;

    /**
     * 业务编码
     */
    @NotBlank(message = "业务编码不可为空！")
    private String businessCode;

    /**
     * 销售主体编码
     */
    @NotBlank(message = "销售主体编码不可为空！")
    private String bizSubjectCode;

    /**
     * 销售主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 机构编码(业务基点)
     */
    @NotBlank(message = "机构不可为空！")
    private String enterpriseCode;

    /**
     * 机构简称（业务基点）
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 是否人保；0否、1是
     */
    private Long isPicc;

    /**
     * 发生日期
     */
    @NotNull(message = "发生日期不可为空！")
    private LocalDate businessDate;

    /**
     * 业务金额
     */
    @DecimalMin(value = "0.001",message = "业务金额不可为空！")
    @DecimalMax(value = "99999999.999", message = "业务金额应该大于0且小于1亿的数字，最多3位小数")
    @Digits(integer = 9, fraction = 3, message = "业务金额应该大于0且小于1亿的数字，最多3位小数")
    private BigDecimal businessAmount;

    /**
     * 结算金额
     */
    @DecimalMin(value = "0.001",message = "结算金额应该大于0且小于1亿的数字，最多3位小数！")
    @DecimalMax(value = "99999999.999", message = "结算金额应该大于0且小于1亿的数字，最多3位小数")
    @Digits(integer = 9, fraction = 3, message = "结算金额应该大于0且小于1亿的数字，最多3位小数")
    private BigDecimal settleAmount;

    /**
     * 说明
     */
    private String introduction;

    /**
     * * 上传的新文件
     * */
    private List<SettleEnterpriseToBusinessTransactionFileSaveReq> settleEnterpriseToBusinessTransactionFileSaveReqList;
    /**
     * 删除的附件id
     * */
    private List<Long> deletedFileIds;
}