package com.roco.settle.api.request.supplier.supplychain;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 供应商收款账户
 * @author lanqian
 */
@Data
public class ReceiptAccountReq implements Serializable {

	/**
	 * ID
	 */
	private Long id;

	/**
	 *  收款账户编号
	 */

	private String accountNo;

	/**
	 * 账户名称
	 */
	private String accountName;

	/**
	 * 账户类型，对公 PUBLIC 对私 PRIVATE
	 */
	private String type;

	/**
	 * 开户银行
	 */
	private String bank;

	/**
	 * 开户名称
	 */
	private String name;

	/**
	 * 开户支行
	 */
	private String subbranch;

	/**
	 * 开户账号
	 */
	private String account;

	/**
	 * 开户电话
	 */
	private String mobile;

	/**
	 * 开户地址
	 */
	private String address;

	/**
	 * 是否默认收款账户
	 */
	private String isDefault;

	/**
	 *  供应商编号
	 */
	private String supplierNo;
}
