package com.roco.settle.api.entity.productconfig;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.StatusEnum;
import com.roco.settle.api.enums.product.ProductNature;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/3/23 15:43</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class SettleEnterpriseProduct implements Serializable {
    /**
     * 机构商品配置编码
     */
    @Id
    private String code;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String simpleName;

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品类型编码
     */
    private String productTypeCode;
    /**
     * 商品类型名称
     */
    private String productTypeName;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 品牌编码
     */
    private String brandCode;
    /**
     * 面值
     */
    private BigDecimal faceValue;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 结算模式
     */
    private String settleModel;
    /**
     * 第三方产品采购价
     */
    private BigDecimal purchasePrice;
    /**
     * 机构产品销售价
     */
    private BigDecimal sellPrice;
    /**
     * 商品状态
     */
    private Integer productStatus;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 推放服务系数
     */
    private BigDecimal psfRatio;

    /**
     * 人保机构号
     */
    private String piccOrgCode;
    /**
     * 是否默认配置
     */
    private String isDefault;

    /**
     * 默认通道产品
     */
    private String channelProductCode;

    /**
     * 默认通道产品名称
     */
    private String channelProductName;


    /**
     * 产品性质
     */
    @Column(name = "nature")
    private ProductNature nature;

    /**
     * 通道产品数
     */
    private Integer channelProductCount;



    /**
     * 销售主体编号
     */
    private String subjectCode;

    /**
     * 销售主体简称
     */
    private String subjectSimpleName;


    /**
     * 销售主体可售产品编号
     */
    private String subjectProductCode;


    /**
     * 销售主体可售产品销售价
     */
    private BigDecimal subjectProductSellPrice;


    /**
     * 是否使用产品面值作为充值面值
     */
    private Boolean  userFaceValue;

    /**
     * 上下架
     */
    @Column(name = "available")
    private StatusEnum available;

    /**
     *机构产品拆单金额
     */
    private Integer amountLimit ;


    /**
     * 第三方产品对应渠道拆单限额
     */
    private BigDecimal thirdProductAmountLimit;


    /**
     * 机构产品拆单金额说明
     */
    private String amountLimitRemark;
}