package com.roco.settle.api.request.order.payment;

import com.roco.settle.api.enums.order.payment.PaymentOrderMatterTypeEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author djt
 * @date 2020/02/27
 */
@Setter
@Getter
public class SupplierPaymentApplySaveReq implements Serializable {

    /**
     * 业务主体code
     */
    @NotBlank
    private String bizSubjectCode;

    /**
     * 业务主体简称
     */
    private String bizSubjectSimpleName;
    /**
     * 供应商code
     */
    @NotBlank
    private String supplierCode;

    /**
     * 供应商名称
     */
    @NotBlank
    private String  supplierSimpleName;
    /**
     * 对私结算事项申请单
     */
    @NotBlank
    private String matterNo;


    /**
     * 对私转账申请单号
     */
    @NotBlank
    private String transferApplyNo;

    /**
     * 对私转账申请名称
     */
    private String  privateTransferItemName;

    /**
     * 支付总金额(元)
     */
    private BigDecimal amount;

    /**
     * 支付笔数
     */
    private Integer cnt;

    /**
     * 对私结算事项名称
     */
    private String transferApplyName;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     *业务基点简称
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号
     */
    private String piccOrgCode;


    /**
     * 事项类型
     */
    private PaymentOrderMatterTypeEnum matterType;


}
