package com.roco.settle.api.request.policy;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author luoyingchang
 * @date 2020-07-14
 */
@Getter
@Setter
public class PolicyGiftDirectDetailQueryReq implements Serializable {


    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 明细编号(唯一)
     */
    private String detailNo;

    /**
     * 机构编码
     */
    private String enterpriseCode;



    /**
     * 推修码
     */
    private String repairNo;



    /**
     * 手机号
     */
    private String mobile;



    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 状态: 草稿:draft、作废:invalid、待处理:pending、待结算:settling、完成:finish
     */
    private String status;


    /**
     * 业务状态 待处理:pending、已处理:processed、已作废:invalid
     */
    private String bizStatus;

    /**
     * 结算状态 未结算:unsettled、已结算:settled
     */
    private String settleStatus;

    private List<String> enterpriseCodes;


    /**
     * 默认不显示草稿
     */
    private boolean showDraft;

    /**
     * 申请人id
     */
    private Integer createUser;

    /**
     * 申请人类型 customer, system
     */
    private String createUsertype;

}
