package com.roco.settle.api.request.settlecapital;

import com.roco.settle.api.enums.IsEnum;
import com.roco.settle.api.enums.StatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/2/5 10:16</dd>
 * <dd>@author：zhanghs</dd>
 * </dl>
 */
@Data
public class SettleCapitalAccountReq implements Serializable {

    /**
     * 账户编码
     */
    private String accountCode;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String enterpriseSimpleName;

    /**
     * 机构简称拼音
     */
    private String enterpriseNamePinyin;

    /**
     * 机构简称首字母
     */
    private String enterpriseNameFirtPinyin;

    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    /**
     * 存入总金额
     */
    private BigDecimal totalAmount;

    /**
     * 账户余额
     */
    private BigDecimal canAmount;

    /**
     * 已结算总额
     */
    private BigDecimal settledAmount;

    /**
     * 未结算总额
     */
    private BigDecimal unsettledAmount;

    /**
     * 未结算订单数
     */
    private Integer unsettledOrderCnt;

    /**
     * 已结算订单数
     */
    private Integer settledOrderCnt;

    /**
     * 存款次数
     */
    private Integer depositCnt;

    /**
     * 结算次数
     */
    private Integer settledCnt;

    /**
     * 业务主体是否垫资
     */
    private IsEnum debt;

    /**
     * 垫资金额
     */
    private BigDecimal debtAmount;

    /**
     * 账户状态
     */
    private StatusEnum status;

    /**
     * 版本号
     */
    private Integer revision;


    /**
     * 创建人id
     */
    private long createUser;

    /**
     * 创建人姓名
     */
    private String createUsername;

    /**
     * 创建日期
     */
    private LocalDate createDate;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private long updateUser;

    /**
     * 更新人姓名
     */
    private String updateUsername;

}