package com.roco.settle.api.service;

import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseBasePointApply;
import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseBasePointLog;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.enterprisetansfer.basepoint.EnterpriseBasePointApplyReq;
import com.roco.settle.api.request.enterprisetansfer.basepoint.EnterpriseBasePointOperateReq;
import com.roco.settle.api.request.enterprisetansfer.basepoint.EnterpriseBasePointQueryReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * @author Andrew
 * @create 2020/2/29 6:51 下午
 */
public interface EnterpriseBasePointService {

    /**
     * 结算申请
     * @param request
     * @return
     */
    CommonResponse<String> apply(CommonRequest<EnterpriseBasePointApplyReq> request);


    /**
     * 分页查询
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseBasePointApply> page(CommonQueryPageRequest<EnterpriseBasePointQueryReq> request);


    /**
     * 删除， 确认 ，取消
     * @param request
     * @return
     */
    CommonResponse<Boolean> operate(CommonRequest<EnterpriseBasePointOperateReq> request);


    /**
     * 详情
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseBasePointApply> detail(CommonRequest<EnterpriseBasePointQueryReq> request);


    /**
     * 日志查询
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseBasePointLog> log(CommonQueryPageRequest<EnterpriseBasePointQueryReq> request);
}
