package com.roco.order.api.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.*;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * (OrderOilCard)实体类
 *
 * @author hsf
 * @since 2020-03-19 08:51:09
 */
@Setter
@Getter
@ToString
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "order_oil_card")
public class OrderOilCard implements Serializable {

    @Id
    private Long id;

    /**
     * 油卡申请单号  
     */
    private String applyNo;

    /**
     * 油卡明细号  
     */
    private String detailNo;

    /**
     * 油卡订单号  
     */
    private String orderNo;

    /**
     * 业务基点编号  
     */
    private String enterpriseCode;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 卡账户类型-用于判断扣除额度方式(SEP_ACC-专项账户,TOTAL_ACC-通用账户)  
     */
    private String ledgerType;

    /**
     * 专项账户编码  
     */
    private String ledgerSepNo;

    /**
     * 通用账户编码  
     */
    private String ledgerCommNo;

    /**
     * 个人账号编码  
     */
    private String ledgerPersonNo;

    /**
     * 资金账户编码  
     */
    private String ledgerFundsNo;

    /**
     * 状态  
     */
    private String status;

    /**
     * 销售点数  
     */
    private BigDecimal settlePoint;

    /**
     * 售价
     */
    private BigDecimal sellPrice;

    /**
     * 客户到账价(oil_card_recharge_detail.amount)
     */
    private BigDecimal arrivePrice;

    /**
     * 明细价格(拆单前价格, gift_recharge_detail.recharge_amount)  
     */
    private BigDecimal detailPrice;

    /**
     * 手机号  
     */
    private String mobile;

    /**
     * 发放费率  
     */
    private BigDecimal rechargeRate;

    /**
     * 增发金额,(实发与基准的差)  
     */
    private BigDecimal diffAmount;

    /**
     * 增发比例  
     */
    private BigDecimal diffRate;

    /**
     * 基准金额  
     */
    private BigDecimal baseAmount;

    /**
     * 基准费率  
     */
    private BigDecimal baseRate;

    /**
     * 保单号  
     */
    private String insuranceNo;

    /**
     * 保费  
     */
    private BigDecimal insurancePrice;

    /**
     * 净保费  
     */
    private BigDecimal insuranceNetPremium;

    /**
     * 保单状态  
     */
    private String insuranceStatus;

    /**
     * 推修码  
     */
    private String insuranceRepairNo;

    /**
     * 归属机构代码  
     */
    private String insuranceOrgNo;

    /**
     * 归属机构名称  
     */
    private String insuranceOrgName;

    /**
     * 保单起保日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime insuranceStartDate;

    /**
     * 保单终保日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime insuranceEndDate;

    /**
     * 车主姓名  
     */
    private String carOwnerName;

    /**
     * 车牌号  
     */
    private String carNumber;

    /**
     * 登记人  
     */
    private String recorder;

    /**
     * 出单人  
     */
    private String drawer;

    /**
     * 出单人手机号  
     */
    private String drawerMobile;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 审核通过时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime approveTime;

    /**
     * 机构发放时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime enterpriseRechargeTime;

    /**
     * 平台发放时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime platformRechargeTime;

    /**
     * 到账时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime arriveTime;

    /**
     * 撤回时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime revokeTime;

   

}