package com.roco.settle.api.entity.enterprisesettle;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.roco.settle.api.util.DateUtil;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/** 业务基点->结算对私转账申请 操作日志
 * @author zhangmin
 * @date 2020/2/29
 */
@Setter
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
@Table(name = "settle_enterprise_private_transfer_apply_log")
public class SettleEnterprisePrivateTransferApplyLog implements Serializable {
    @Id
    private Long id;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 操作之前的状态
     */
    private String beforeStatus;

    /**
     * 操作备注
     */
    private String operationDesc;

    /**
     * 操作类型
     */
    private String operationType;

    /**
     * 操作之后的状态
     */
    private String afterStatus;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

}
