package com.roco.settle.api.entity.remittance;


import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务基点打款工单-服务清单申请单关联表(SettleEnterpriseRemittanceReferenceService)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:24:44
 */
@Data
@Table(name = "settle_enterprise_remittance_reference_service")
public class SettleEnterpriseRemittanceReferenceService implements Serializable {

   
    @Id
    private Long id;

    /**
     * 打款工单  
     */
    private String remittanceCode;

    /**
     * 服务清单申请单编码  
     */
    private String serviceApplyCode;

    /**
     * 状态(1已使用，0已释放)  
     */
    private Integer status;

   

}