/*
 * Decompiled with CFR 0.152.
 */
package com.roco.settle.api.enums.order;

import com.roco.settle.api.enums.order.OrderStatusEnum;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OrderOperationTypeEnum {
    CREATE(new OrderStatusEnum[]{OrderStatusEnum.EMPTY}, OrderStatusEnum.WAIT_INVOICE),
    EDIT_INVOICE(new OrderStatusEnum[]{OrderStatusEnum.WAIT_INVOICE}, OrderStatusEnum.WAIT_INVOICE),
    CONFIRM_INVOICED(new OrderStatusEnum[]{OrderStatusEnum.WAIT_INVOICE}, OrderStatusEnum.INVOICED),
    EDIT_EXPRESSAGE(new OrderStatusEnum[]{OrderStatusEnum.INVOICED}, OrderStatusEnum.INVOICED),
    CONFIRM_RECEIVE(new OrderStatusEnum[]{OrderStatusEnum.INVOICED}, OrderStatusEnum.RECEIVED),
    INVALID(new OrderStatusEnum[]{OrderStatusEnum.INVOICED, OrderStatusEnum.WAIT_INVOICE}, OrderStatusEnum.CANCEL);

    private OrderStatusEnum[] before;
    private OrderStatusEnum after;

    private OrderOperationTypeEnum(OrderStatusEnum[] before, OrderStatusEnum after) {
        this.before = before;
        this.after = after;
    }

    public List<String> getBefore() {
        return Stream.of(this.before).map(Enum::name).collect(Collectors.toList());
    }

    public String getAfter() {
        return this.after.name();
    }
}

