package com.roco.settle.api.entity.supplier;

import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMax;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Andrew
 * @create 2020/2/19 10:58 上午
 */

@Data
@Table(name = "product_settlement")
public class ProductSettlement implements Cloneable, Serializable {

    @Id
    private Long id;
    /**
     * 商品编码
     */
    private String productCode;
    /**
     * 企业编码
     */
    private String enterpriseCode;
    /**
     *
     * 结算模式(0进销差,1收推广服务费)
     *
     * @see com.roco.settle.api.enums.ProductSettlementModeEnum
     */
    private Integer mode;
    /**
     * 采购价
     */
    private BigDecimal purchasePrice;
    /**
     * 中介代理服务费(Intermediary agency service fee
     */
    private BigDecimal iyasFee;
    /**
     * 保险代理服务费(Insurance agency service fee)
     */
    private BigDecimal ieasFee;
    /**
     * 销售价
     */
    @DecimalMax(value ="9999999.999")
    private BigDecimal sellPrice;
    /**
     * 推广服务费系数(Promotion service fee ratio
     */
    private BigDecimal psfRatio;
    /**
     * 说明
     */
    private String remark;

    private Long createUser;

    private LocalDateTime createTime;

    private String createUsertype;

    private String createName;

    private Long updateUser;

    private LocalDateTime updateTime;

    private String updateUsertype;

    private String updateName;

    @Override
    public ProductSettlement clone() throws CloneNotSupportedException {
        return (ProductSettlement) super.clone();
    }


}
