package com.roco.settle.api.enums.remittance;

public enum SettleEnterpriseRemittanceStatusEnum {
    /**
     * 草稿
     */
    DRAFT("草稿"),
    /**
     * 待确认
     * */
    WAIT_CONFIRM("待确认"),
    /**
     * 待开票
     * */
    WAIT_INVOICE("待开票"),
    /**
     * 已开票
     * */
    INVOICED("已开票"),
    /**
     * 已寄送发票
     * */
    SENT("已寄送发票"),
    /**
     * 客户已收到发票
     * */
    SINGED("客户已收发票"),
    /**
     * 客户已付款
     * */
    PAID("客户已付款"),
    /**
     * 财务收款确认
     */
    RECEIPTED("财务已收款"),
    /**
     * 已取消
     * */
    CANCELLED("已取消");
    private String name;

    SettleEnterpriseRemittanceStatusEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        if (i == null) {
            return "";
        }
        SettleEnterpriseRemittanceStatusEnum[] values = SettleEnterpriseRemittanceStatusEnum.values();
        return i >= 0 && i < values.length ? values[i].getName() : "" + i;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
