package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.Brand;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.base.NoArgsRequest;
import com.roco.settle.api.request.supplier.brand.BrandQueryReq;
import com.roco.settle.api.request.supplier.brand.BrandSaveReq;
import com.roco.settle.api.request.supplier.brand.BrandUpdateReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

/**
 * @author Andrew
 * @create 2020/2/21 11:11 上午
 */
public interface BrandService {

    CommonResponse<Brand> detail(CommonRequest<BasePrimaryKeyRequest> request);

    CommonResponse<Boolean> save(CommonRequest<BrandSaveReq> request);

    CommonResponse<Boolean> update(CommonRequest<BrandUpdateReq> request);

    CommonResponse<Boolean> delete(CommonRequest<BasePrimaryKeyRequest> request);

    CommonResponse<List<Brand>> find(CommonRequest<BrandQueryReq> request);

    CommonQueryPageResponse<Brand> page(CommonQueryPageRequest<BrandQueryReq> request);

    CommonResponse<Integer> getMaxSerialNumber(CommonRequest<NoArgsRequest> request);

}
