package com.roco.user.api.entity;

import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/10/29 17:55</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "enterprise_user")
public class EnterpriseUser implements Serializable {
    @Id
    private Integer id;

    /**
     *  
     */
    private String mobile;

    /**
     *  
     */
    private String name;

    /**
     * 账号名拼音
     */
    private String namePinyin;

    /**
     *  
     */
    private String password;

    /**
     *  
     */
    private String salt;

    /**
     *  
     */
    private String jobNo;

    /**
     *  
     */
    private String enterpriseCode;

    /**
     *  
     */
    private String abbreviation;

    /**
     * 业务员数据权限
     */
    private String permit;

    /**
     * no无 self 本企业所有合作商户 self_children 本企业及其下级企业所有合作商户 指定合作商户 locate
     */
    private String merchantPermit;

    /**
     *  账号说明
     */
    private String intro;

    /**
     * 账号名
     */
    private String acctName;

    /**
     * 账号状态
     */
    private String status;

    /**
     * 总额度
     */
    private BigDecimal totalAmount;

    /**
     * 可用额度
     */
    private BigDecimal availableAmount;

    /**
     * 限额状态
     */
    private String limitStatus;

    /**
     * 额度管理状态
     */
    private String manageStatus;

    /**
     * self 按企业可出单机构 locate 指定可出单机构
     */
    private String policyOrgType;

    private String createUsertype;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     *  创建人姓名
     */
    private String createName;

    private String updateUsertype;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     *  更新人姓名
     */
    private String updateName;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 登录引导
     */
    private String loginGuide;

    /**
     * 身份证号码
     */
    private String idCard;

    /**
     * 业务账号标识
     */
    private String businessAccountFlag;

    /**
     * 业务账号类型
     */
    private String businessAccountType;

    /**
     * 账号是否可登陆PC端是否上架
     */
    private String isPc;

    /**
     *  商户编号
     */
    private String businessCode;

    /**
     *  商户名称
     */
    private String businessName;

    /**
     *  账号性质
     */
    private String nature;

    /**
     * 关联机构数(自身与enterprise_user_ref)
     */
    private Integer enterpriseRefCnt;

    /**
     * 是否需要用户自行设置身份
     */
    private String setPosition;

    /**
     * 用户身份
     */
    private String userPositionJson;

}