package com.roco.settle.api.entity.agent;

import com.roco.settle.api.enums.base.LogTypeEnum;
import lombok.Builder;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/10/30 14:22</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Builder
public class SettleStandardPackageLog implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 标准套餐编码（settle_standard_package.code）
     */
    private String packageCode;

    /**
     * 日志类型
     */
    @Column(name = "log_type")
    private LogTypeEnum logType;

    /**
     * 产品面值
     */
    private BigDecimal faceValue;

    /**
     * 产品采购价
     */
    private BigDecimal purchasingPrice;

    /**
     * 产品数量
     */
    private Integer productCount;

    /**
     * 旧套餐产品明细
     */
    private String beforeItemJson;

    /**
     * 新套餐产品明细
     */
    private String afterItemJson;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人姓名
     */
    private String createName;

}