package com.roco.settle.api.request.agent;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author djt
 * @Description: 标准套餐请求实体
 * @date 2020/10/30 11:42
 */
@Data
public class StandardPackageSaveReq implements Serializable {

    /**
     * id
     */
    private Long  id;

    /**
     * 机构编码
     */
    @Length(max=32)
    @NotBlank(message = "机构编码不能为空")
    private String enterpriseCode;

    /**
     * 机构简称
     */
    @Length(max=250)
    @NotBlank(message = "机构简称不能为空")
    private String enterpriseSimpleName;

    /**
     * 集成商编号(settle_biz_subject.code)
     */
    @Length(max=32)
    @NotBlank(message = "集成商编号不能为空")
    private String subjectCode;

    /**
     * 集成商简称(settle_biz_subject.simple_name)
     */
    @Length(max=64)
    @NotBlank(message = "集成商简称不能为空")
    private String subjectSimpleName;

    /**
     * 套餐名称
     */
    @Length(max=64)
    @NotBlank(message = "套餐名称不能为空")
    private String packageName;

    /**
     * 套餐编号（用户自定义）
     */
    @Length(max=32)
    @NotBlank(message = "套餐编号不能为空")
    private String packageCode;

    /**
     * 套餐总市场价
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull(message = "套餐总市场价不能为空")
    private BigDecimal faceValue;

    /**
     * 套餐总成本
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull(message = "套餐总成本不能为空")
    private BigDecimal cost;

    /**
     * 套餐总采购价
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull(message = "套餐总采购价不能为空")
    private BigDecimal purchasingPrice;

    /**
     * 套餐产品数
     */
    @Min(1)
    @NotNull(message = "套餐产品数不能为空")
    private Integer productCount;

    /**
     * 套餐说明
     */
    @Length(max = 500,message = "套餐产品说明不能超过500个字符")
    private String remark;

    /**
     * 套餐状态
     */
    @Min(0)
    @Max(1)
    @NotNull(message = "套餐状态不能为空")
    private Integer status;

    /**
     * 套餐明细
     */
    @Size(min = 1)
    @NotNull(message = "套餐明细不能为空")
    @Valid
    private List<SettleStandardPackageItemSaveReq> items;

}
