package com.roco.settle.api.request.supplier.supplychain;

import com.roco.settle.api.enums.IsEnum;
import com.roco.settle.api.enums.ReceiptAccountTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 供应商收款账户
 * @author lanqian
 */
@Data
public class ReceiptAccountSaveReq implements Serializable {

	/**
	 * ID
	 */
	private Long id;

	/**
	 *  收款账户编号
	 */

	private String accountNo;

	/**
	 * 账户名称
	 */
	@NotBlank(message = "账户名称不可以为空！")
	private String accountName;

	/**
	 * 账户类型，对公 PUBLIC 对私 PRIVATE
	 */
    @NotBlank(message = "账户类型不可以为空！")
	private String type;

	/**
	 * 开户银行
	 */
    @NotBlank(message = "开户银行不可以为空！")
	private String bank;

	/**
	 * 开户名称
	 */
    @NotBlank(message = "开户名称不可以为空！")
	private String name;

	/**
	 * 开户支行
	 */
    @NotBlank(message = "开户支行不可以为空！")
	private String subbranch;

	/**
	 * 开户账号
	 */
    @NotBlank(message = "开户账号不可以为空！")
	private String account;

	/**
	 * 开户电话
	 */
	private String mobile;

	/**
	 * 开户地址
	 */
	private String address;

	/**
	 * 是否默认收款账户
	 */
    @NotBlank(message = "是否默认收款账户不可以为空！")
	private String isDefault;

	/**
	 *  供应商编号
	 */
    @NotBlank(message = "供应商编码不可以为空！")
	private String supplierNo;
}
