package com.roco.settle.api.response.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author
 */
@Data
public class SupplierInvoiceOrderExpressExtResp implements Serializable {

    /**
     * 发票张数
     */
    private Integer invoiceCnt;


    /**
     * 发票号码
     */
    private String invoiceCode;



    @Id
    private Long id;

    /**
     * 寄送信息编码
     */
    private String code;

    /**
     * 开票订单号
     */
    private String orderCode;

    /**
     * 寄送类型
     */
    private String type;

    /**
     * 快递公司
     */
    private String expressCompany;

    /**
     * 快递单号
     */
    private String expressNumber;

    /**
     * 寄送时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    @Column(name="send_time")
    private LocalDateTime sendTime;

    /**
     * 签收时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    @Column(name="receive_time")
    private LocalDateTime receiveTime;

    /**
     * 签收人
     */
    private String receiveUser;


    /**
     * 寄送负责人
     */
    private  String courier;

    /**
     * 快递单截图
     */
    private String expressImage;

    /**
     * 签收凭证
     */
    private String receiveImage;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    @Column(name = "create_time")
    private LocalDateTime createTime;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    @Column(name = "update_time")
    private LocalDateTime updateTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
}
