package com.roco.settle.api.entity.billing;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import com.roco.settle.api.enums.billing.SettleSubjectBillingStatusEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务主体开票工单(SettleSubjectBillingRecord)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:26:29
 */
@Data
@Table(name = "settle_subject_billing_record")
public class SettleSubjectBillingRecord implements Serializable {

   
    @Id
    private Long id;

    /**
     * 业务主体开票工单号  
     */
    private String code;

    /**
     * 关联打款工单  
     */
    private String remittanceCode;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人id  
     */
    private Long createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

    /**
     * 创建人类型  
     */
    private String createUsertype;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id  
     */
    private Long updateUser;

    /**
     * 更新人姓名  
     */
    private String updateName;

    /**
     *  更新人类型  
     */
    private String updateUsertype;

    /**
     * 状态  
     */
    @Column(name = "status")
    private SettleSubjectBillingStatusEnum status;

    /**
     * 逻辑删除（0：未删除，1：已删除）  
     */
    private Integer deleted;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 机构编码(业务基点)  
     */
    private String enterpriseCode;

    /**
     * 机构简称（业务基点）  
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号  
     */
    private String piccOrgCode;

    /**
     * 工单名称  
     */
    private String name;

    /**
     * 工单说明  
     */
    private String introduction;

    /**
     * 工单类型  
     */
    @Column(name="type")
    private String type;

    /**
     * 发票金额  
     */
    private BigDecimal invoiceTotalAccount;

    /**
     * 发票含税金额  
     */
    private BigDecimal invoiceTaxAccount;

    /**
     * 发票总笔数  
     */
    private Long invoiceTotalCnt;

    /**
     * 确认已开票时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime invoiceConfirmationTime;

    /**
     * 确认已寄送时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime sendConfirmationTime;

    /**
     * 确认客户已收票时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime signConfirmationTime;

    /**
     * 取消时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime cancelTime;


    /**冗余信息*/
    @Transient
    private BigDecimal remittanceAmount;



}