package com.roco.settle.api.entity.privatetransfer;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 对私转账-账户转账申请表(SettlePrivateAttachApply)实体类
 *
 * @author hsf
 * @since 2020-02-29 13:27:37
 */
@Data
@Table(name = "settle_private_attach_apply")
public class SettlePrivateAttachApply implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单编码  
     */
    private String applyNo;

    /**
     * (settle_private_apply.transfer_apply_code)
     */
    private String transferApplyCode;

    /**
     * 业务基点结算点数  
     */
    private BigDecimal settlePoint;

    /**
     * 业务基点结算金额(结算金额计算公式=转账总金额/（1-结算点数）
)  
     */
    private BigDecimal settleAmount;

    /**
     * 总笔数  
     */
    private Long totalCnt;

    /**
     * 总金额  
     */
    private BigDecimal totalAmount;

    /**
     * 附件名称  
     */
    private String attachName;

    /**
     * 申请单备注  
     */
    private String remark;

    /**
     * 附件url  
     */
    private String attachUrl;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建人  
     */
    private String createUser;

    /**
     * 创建人名称  
     */
    private String createName;

    /**
     * 更新人  
     */
    private String updateUser;

    /**
     * 更新人名称  
     */
    private String updateName;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

   

}