package com.roco.settle.api.request.agent;

import lombok.Data;

import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author djt
 * @Description: 套餐明细产品
 * @date 2020/10/30 13:22
 */
@Data
public class SettleStandardPackageItemSaveReq implements Serializable {


    /**
     * 机构产品编码（settle_enterprise_product_rel.code）
     */
    @NotBlank(message = "机构产品编码不能为空")
    private String productCode;

    /**
     * 机构产品简称
     */
    @NotBlank(message = "机构产品简称不能为空")
    private String productSimpleName;

    /**
     * 产品市场价
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull(message = "产品市场价不能为空")
    private BigDecimal faceValue;

    /**
     * 产品成本
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull(message = "产品成本不能为空")
    private BigDecimal cost;

    /**
     * 产品采购价
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull(message = "产品采购价不能为空")
    private BigDecimal purchasingPrice;

    /**
     * 产品数量
     */
    @Min(1)
    @NotNull(message = "产品数量不能为空")
    private Integer productCount;

}
