package com.roco.settle.api.entity.agent;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author djt
 * @Description: 代理人标准套餐
 * @date 2020/10/30 11:29
 */
@Data
public class SettleStandardPackage implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 套餐唯一编码（系统生成）
     */
    private String code;

    /**
     * 机构编码
     */
    @NotBlank(message = "机构编码不能为空")
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String enterpriseSimpleName;

    /**
     * 集成商编号(settle_biz_subject.code)
     */
    private String subjectCode;

    /**
     * 集成商简称(settle_biz_subject.simple_name)
     */
    private String subjectSimpleName;

    /**
     * 套餐名称
     */
    private String packageName;

    /**
     * 套餐编号（用户自定义）
     */
    private String packageCode;

    /**
     * 套餐总市场价
     */
    private BigDecimal faceValue;

    /**
     * 套餐总成本
     */
    private BigDecimal cost;

    /**
     * 套餐总采购价
     */
    private BigDecimal purchasingPrice;

    /**
     * 套餐产品数
     */
    private Integer productCount;

    /**
     * 套餐说明
     */
    private String remark;

    /**
     * 套餐状态
     */
    private Integer status;

    /**
     * 创建人id
     */
    private Integer createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     *创建人名称
     */
    private String createName;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     *更新人名称
     */
    private String updateName;
}
