package com.roco.settle.api.enums.enterprisesettle;

import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 业务基点 结算对私转账 操作枚举
 * @author zhangmin
 */
public enum EnterprisePrivateTransferApplyOperate {

    /**
     * 提交
     */
    SUBMIT(new EnterprisePrivateTransferApplyStatus[]{EnterprisePrivateTransferApplyStatus.NULL,
            EnterprisePrivateTransferApplyStatus.DRAFT},
            EnterprisePrivateTransferApplyStatus.PENDING),

    /**
     * 删除
     */
    DELETE(new EnterprisePrivateTransferApplyStatus[]{EnterprisePrivateTransferApplyStatus.DRAFT},
            EnterprisePrivateTransferApplyStatus.DELETED),


    /**
     * 处理
     */
    COMPLETE(new EnterprisePrivateTransferApplyStatus[]{EnterprisePrivateTransferApplyStatus.PENDING},
            EnterprisePrivateTransferApplyStatus.COMPLETE),

    /**
     * 取消
     */
    CANCEL(new EnterprisePrivateTransferApplyStatus[]{
            EnterprisePrivateTransferApplyStatus.PENDING,
    }, EnterprisePrivateTransferApplyStatus.CANCEL);


    @Getter
    private EnterprisePrivateTransferApplyStatus[] before;
    @Getter
    private EnterprisePrivateTransferApplyStatus after;


    public List<String> getBeforeList() {
        return Stream.of(before).map(EnterprisePrivateTransferApplyStatus::name).collect(Collectors.toList());
    }

    EnterprisePrivateTransferApplyOperate(EnterprisePrivateTransferApplyStatus[] before, EnterprisePrivateTransferApplyStatus after) {
        this.before = before;
        this.after = after;
    }
}
