package com.roco.settle.api.service;

import com.roco.settle.api.entity.SettleBizSubject;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.base.NoArgsRequest;
import com.roco.settle.api.request.settlebizsubject.SettleBizSubjectPageReq;
import com.roco.settle.api.request.settlebizsubject.SettleBizSubjectQueryReq;
import com.roco.settle.api.request.settlebizsubject.SettleBizSubjectSaveReq;
import com.roco.settle.api.request.settlebizsubject.SettleBizSubjectUpdateStatusReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.settlebizsubject.SettleBizSubjectResp;

import java.util.List;

/**
 * 结算业务主体
 * @author Andrew
 * @create 2020/2/4 9:04 下午
 */
public interface SettleBizSubjectService {


    /**
     * 新增业务主体
     * @param request
     * @return
     */
    CommonResponse<Boolean> saveBizSubject(CommonRequest<SettleBizSubjectSaveReq> request);


    /**
     * 分页查询业务主体
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SettleBizSubjectResp> pageBizSubject(CommonQueryPageRequest<SettleBizSubjectPageReq> pageRequest);



    /**
     * 修改主体
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateBizSubject(CommonRequest<SettleBizSubjectSaveReq> request);

    /**
     * 修改主体状态
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateBizSubjectStatus(CommonRequest<SettleBizSubjectUpdateStatusReq> request);


    /**
     * 查询主体不分页
     * @param request
     * @return
     */
    CommonResponse<List<SettleBizSubject>> selectSubject(CommonRequest<SettleBizSubjectPageReq > request);

    /**
     * 查询北京大城和广州大城业务主体编号
     * @param request
     * @return
     */
    CommonResponse<List<SettleBizSubject>> selectInvoiceBizSubject(CommonRequest<NoArgsRequest> request);

    CommonResponse<SettleBizSubjectResp> detail(CommonRequest<SettleBizSubjectQueryReq> request);
}
