package com.roco.settle.api.entity.billing;

import java.time.LocalDateTime;
import java.util.Date;

import com.roco.settle.api.enums.billing.SettleSubjectBillingOperationEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务基点打款工单操作记录(SettleSubjectBillingOperation)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:26:15
 */
@Data
@Table(name = "settle_subject_billing_operation")
public class SettleSubjectBillingOperation implements Serializable {

    @Id
    private Long id;

    /**
     * 打款工单  
     */
    private String billingCode;

    /**
     * 批次号  
     */
    private String batchCode;

    /**
     * 操作类型  
     */
    private SettleSubjectBillingOperationEnum operateType;

    /**
     * 操作名称  
     */
    private String operateName;

    /**
     * 操作说明  
     */
    private String remark;

    /**
     * 操作时间  
     */

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 操作人  
     */
    private Long createUser;

    /**
     * 操作人姓名  
     */
    private String createName;

    /**
     *  操作人类型  
     */
    private String createUsertype;

    /**
     * 逻辑删除（0：未删除，1：已删除）  
     */
    private Integer deleted;

   

}