package com.roco.settle.api.request.order;

import com.roco.settle.api.enums.order.SettleMatterType;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author dongjuntong
 */
@Data
public class SupplierInvoiceSaveReq {

    /**
     * 事项编号
     */
    private String matterCode;

    /**
     * 事项名称
     */
    private String matterName;

    /**
     *开票总金额
     */
    private BigDecimal amount;

    /**
     * 事项类型
     */
    private SettleMatterType settleMatterType;

    /**
     * 业务主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体简称
     */
    private String bizSubjectCode;

    /**
     * 供应商编码
     */
    private String supplierCode;


    /**
     * 供应商名称
     */
    private String supplierName;


    /**
     * 营业执照名称
     */
    private String licenseName;

    /**
     * 收款账户编码
     */
    private String receiveAccountCode;


    /**
     * 收款账户类型
     */
    private String accountType;

    /**
     * 收款账户开户行
     */
    private String bankName;

    /**
     * 收款账户开户支行
     */
    private String bankBranch;

    /**
     * 收款人开户名称
     */
    private String cardName;

    /**
     * 收款卡号
     */
    private String cardNo;

}
