package com.roco.settle.api.service.enterprise.transaction;

import com.roco.settle.api.entity.enterprise.transaction.SettleEnterpriseToConsumerTransaction;
import com.roco.settle.api.entity.enterprise.transaction.SettleEnterpriseToConsumerTransactionOperation;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.base.NoArgsRequest;
import com.roco.settle.api.request.enterprise.transaction.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.enterprise.transaction.SettleEnterpriseToConsumerTransactionRes;

/**
 * 业务基点TOC业务登记(SettleEnterpriseToConsumerTransaction)表服务接口
 *
 * @author 兰倩
 * @since 2020/07/03 14:00
 */
public interface SettleEnterpriseToConsumerTransactionService {
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseToConsumerTransaction
     */
    CommonResponse<SettleEnterpriseToConsumerTransaction> get(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseToConsumerTransaction
     */
    CommonResponse<SettleEnterpriseToConsumerTransactionRes> getExt(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseToConsumerTransaction
     */
    CommonResponse<SettleEnterpriseToConsumerTransactionRes> getByCode(CommonRequest<SettleEnterpriseToConsumerTransactionReq> request);

    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> save(CommonRequest<SettleEnterpriseToConsumerTransactionSaveReq> request);
    /**
     * 更新记录
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> update(CommonRequest<SettleEnterpriseToConsumerTransactionUpdateReq> request);


    /**
     * 确认
     * @param request {id, confirmDate}
     * @return
     * */
    CommonResponse<String> confirm(CommonRequest<SettleEnterpriseToConsumerTransactionReq> request);
    /**
     * 作废
     * @param request
     * @return
     * */
    CommonResponse<Boolean> invalid(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     *处理确认
     * @param request
     * @return
     * */
    CommonResponse<Boolean> handle(CommonRequest<SettleEnterpriseToConsumerTransactionHandleReq> request);
    /**
     * 结算确认
     * @param request
     * @return
     * */
    CommonResponse<Boolean> settle(CommonRequest<SettleEnterpriseToConsumerTransactionSettleReq> request);
    /**
     * 列表-分页
     * @param request 关键字
     * @return 分页查询实体
     */
    CommonQueryPageResponse<SettleEnterpriseToConsumerTransaction> search(CommonQueryPageRequest<SettleEnterpriseToConsumerTransactionPageReq> request);

    /**
     * 查询操作日志
     * */
     CommonQueryPageResponse<SettleEnterpriseToConsumerTransactionOperation> searchOperation(CommonQueryPageRequest<SettleEnterpriseToConsumerTransactionOperationPageReq> request);

    CommonResponse<Boolean> processStatistic(CommonRequest<NoArgsRequest> request);
}